/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.launching;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.internal.ui.wizard.field.IListAdapter;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.util.NameValuePair;
import com.aptana.php.debug.ui.launching.Messages;
import com.aptana.php.debug.ui.launching.NameValuePairInputDialog;
import com.aptana.ui.util.SWTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org2.eclipse.php.internal.ui.wizard.field.ListDialogField;

public class HTTPLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String IMG_LAUNCH_HTTP = "/icons/full/obj16/launch-http.gif";
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_UP = 4;
    private static final int IDX_DOWN = 5;
    private static final String NAME = Messages.HTTPLaunchConfigurationTab_httpLaunchTabName;
    private ListDialogField<NameValuePair> listGET;
    private ListDialogField<NameValuePair> listPOST;

    public HTTPLaunchConfigurationTab() {
        String[] stringArray = new String[6];
        stringArray[0] = Messages.HTTPLaunchConfigurationTab_getAddLabel;
        stringArray[1] = Messages.HTTPLaunchConfigurationTab_getEditLabel;
        stringArray[2] = Messages.HTTPLaunchConfigurationTab_getRemoveLabel;
        stringArray[4] = Messages.HTTPLaunchConfigurationTab_getUpLabel;
        stringArray[5] = Messages.HTTPLaunchConfigurationTab_getDownLabel;
        this.listGET = new EnhancedListDialogField<NameValuePair>(new ListAdapter(), stringArray, (ILabelProvider)new NameValueLabelProvider());
        String[] stringArray2 = new String[6];
        stringArray2[0] = Messages.HTTPLaunchConfigurationTab_postAddLabel;
        stringArray2[1] = Messages.HTTPLaunchConfigurationTab_postEditLabel;
        stringArray2[2] = Messages.HTTPLaunchConfigurationTab_postRemoveLabel;
        stringArray2[4] = Messages.HTTPLaunchConfigurationTab_postUpLabel;
        stringArray2[5] = Messages.HTTPLaunchConfigurationTab_postDownLabel;
        this.listPOST = new EnhancedListDialogField<NameValuePair>(new ListAdapter(), stringArray2, (ILabelProvider)new NameValueLabelProvider());
        ListDialogField.ColumnsDescription columnsDescription = new ListDialogField.ColumnsDescription(new String[]{Messages.HTTPLaunchConfigurationTab_nameColumn, Messages.HTTPLaunchConfigurationTab_valueColumn}, true);
        this.listGET.setTableColumns(columnsDescription);
        this.listPOST.setTableColumns(columnsDescription);
        this.listGET.setRemoveButtonIndex(2);
        this.listGET.setUpButtonIndex(4);
        this.listGET.setDownButtonIndex(5);
        this.listPOST.setRemoveButtonIndex(2);
        this.listPOST.setUpButtonIndex(4);
        this.listPOST.setDownButtonIndex(5);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        Group groupGET = new Group(composite, 0);
        groupGET.setText(Messages.HTTPLaunchConfigurationTab_getGroupText);
        groupGET.setLayout((Layout)new GridLayout(2, false));
        groupGET.setLayoutData((Object)new GridData(1808));
        Control listControlGET = this.listGET.getListControl((Composite)groupGET);
        Composite buttonsControlGET = this.listGET.getButtonBox((Composite)groupGET);
        Group groupPOST = new Group(composite, 0);
        groupPOST.setText(Messages.HTTPLaunchConfigurationTab_postGroupText);
        groupPOST.setLayout((Layout)new GridLayout(2, false));
        groupPOST.setLayoutData((Object)new GridData(1808));
        Control listControlPOST = this.listPOST.getListControl((Composite)groupPOST);
        Composite buttonsControlPOST = this.listPOST.getButtonBox((Composite)groupPOST);
        GridData data = new GridData(1808);
        listControlGET.setLayoutData((Object)data);
        data = new GridData(1808);
        listControlPOST.setLayoutData((Object)data);
        buttonsControlGET.setLayoutData((Object)new GridData(258));
        buttonsControlPOST.setLayoutData((Object)new GridData(258));
        this.setControl((Control)composite);
    }

    public Image getImage() {
        return SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)IMG_LAUNCH_HTTP);
    }

    public String getName() {
        return NAME;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            List GET = configuration.getAttribute("ATTR_HTTP_GET", Collections.EMPTY_LIST);
            List POST = configuration.getAttribute("ATTR_HTTP_POST", Collections.EMPTY_LIST);
            ArrayList<NameValuePair> pairsGET = new ArrayList<NameValuePair>();
            for (String pair : GET) {
                NameValuePair nameValuePair = NameValuePair.fromPairString(pair);
                if (nameValuePair == null) continue;
                pairsGET.add(nameValuePair);
            }
            ArrayList<NameValuePair> pairsPOST = new ArrayList<NameValuePair>();
            for (String pair : POST) {
                NameValuePair nameValuePair = NameValuePair.fromPairString(pair);
                if (nameValuePair == null) continue;
                pairsPOST.add(nameValuePair);
            }
            this.listGET.setElements(pairsGET);
            this.listPOST.setElements(pairsPOST);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Error initializing the HTTP GET/POST configuration dialog", (Throwable)e, (String)"com.aptana.php.debug/debug");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        List elementsGET = this.listGET.getElements();
        ArrayList<String> GET = new ArrayList<String>();
        for (NameValuePair nvp : elementsGET) {
            String pair = nvp.toString();
            GET.add(pair);
        }
        List elementsPOST = this.listPOST.getElements();
        ArrayList<String> POST = new ArrayList<String>();
        for (NameValuePair nvp : elementsPOST) {
            String pair = nvp.toString();
            POST.add(pair);
        }
        configuration.setAttribute("ATTR_HTTP_GET", GET);
        configuration.setAttribute("ATTR_HTTP_POST", POST);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private class EnhancedListDialogField<E>
    extends ListDialogField<E> {
        EnhancedListDialogField(IListAdapter<E> adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected boolean getManagedButtonState(ISelection sel, int index) {
            if (index == 1) {
                return !sel.isEmpty();
            }
            return super.getManagedButtonState(sel, index);
        }

        protected boolean managedButtonPressed(int index) {
            boolean res = super.managedButtonPressed(index);
            if (res) {
                HTTPLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
            return res;
        }
    }

    private class ListAdapter<E>
    implements IListAdapter<E> {
        private ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NameValuePairInputDialog dialog;
            NameValuePair edited = null;
            if (index != 0) {
                edited = (NameValuePair)field.getSelectedElements().get(0);
            }
            if ((index == 0 || index == 1) && (dialog = new NameValuePairInputDialog(HTTPLaunchConfigurationTab.this.getShell(), edited, field.getElements())).open() == 0) {
                NameValuePair result = dialog.getResult();
                if (edited != null) {
                    if (!edited.equals(result)) {
                        field.replaceElement((Object)edited, (Object)dialog.getResult());
                    }
                } else {
                    field.addElement((Object)dialog.getResult());
                }
            }
            HTTPLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }

        public void doubleClicked(ListDialogField field) {
            this.customButtonPressed(field, 1);
        }

        public void selectionChanged(ListDialogField field) {
        }
    }

    private static class NameValueLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private NameValueLabelProvider() {
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            NameValuePair pair = (NameValuePair)element;
            if (columnIndex == 0) {
                return pair.name;
            }
            return pair.value;
        }
    }
}

